-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/style.lua" );

kButtonSpacingX = 145;
kButtonSpacingY = 60;
kTitleY			= 33;

kButtonCollumn = 70;	-- There is two collumns and there is correction from kCenter
kBottom = 438;
kButtonX = kCenter - 150;
kButtonY = kCenter+140;
kDecor1X = 110;
kDecor1Y = 115;
kDecorSpaceX = 150;
kTextDiffY = 1;
kDecor1PriceX = 65;
kDecorPriceTitleOffset = 10;

kUpgradeTypeY = 85;
kUpgradePriceY = 220;

kUpgradeName1 = nil;
kUpgradeName2 = nil;
kUpgradeName3 = nil;

kUpgrade1Price = nil;
kUpgrade2Price = nil;
kUpgrade3Price = nil;

kUpgradeTitle1 = nil;
kUpgradeTitle2 = nil;
kUpgradeTitle3 = nil;

kSold1 = nil;
kSold2 = nil;
kSold3 = nil;

PriceFont = {
  standardFont,
  18,
  MenuButtonFontColor
};

SoldFont = {
  standardFont,
  30,
  RedColor
};

	if(GetCurrentVenueNow() == 1) then
		kUpgradeName1="images/backgrounds/themes/boxingclub/showers";
		kUpgradeName2="images/backgrounds/themes/boxingclub/floors";
		kUpgradeName3="images/backgrounds/themes/boxingclub/walls";
		kUpgradeTitle1="upgrade_title_showers";
		kUpgradeTitle2="upgrade_title_floors";
		kUpgradeTitle3="upgrade_title_walls";
	elseif(GetCurrentVenueNow() == 2) then
		kUpgradeName1="images/backgrounds/themes/cruiseship/showers";
		kUpgradeName2="images/backgrounds/themes/cruiseship/floors";
		kUpgradeName3="images/backgrounds/themes/cruiseship/chairs";
		kUpgradeTitle1="upgrade_title_showers";
		kUpgradeTitle2="upgrade_title_floors";
		kUpgradeTitle3="upgrade_title_chairs";
	elseif(GetCurrentVenueNow() == 3) then
		kUpgradeName1="images/backgrounds/themes/rooftop/showers";
		kUpgradeName2="images/backgrounds/themes/rooftop/floors";
		kUpgradeName3="images/backgrounds/themes/rooftop/windows";
		kUpgradeTitle1="upgrade_title_showers";
		kUpgradeTitle2="upgrade_title_floors";
		kUpgradeTitle3="upgrade_title_windows";
	elseif(GetCurrentVenueNow() == 4) then
		kUpgradeName1="images/backgrounds/themes/zen/showers";
		kUpgradeName2="images/backgrounds/themes/zen/floors";
		kUpgradeName3="images/backgrounds/themes/zen/trees";
		kUpgradeTitle1="upgrade_title_showers";
		kUpgradeTitle2="upgrade_title_floors";
		kUpgradeTitle3="upgrade_title_trees";
	elseif(GetCurrentVenueNow() == 5) then
		kUpgradeName1="images/backgrounds/themes/olympus/showers";
		kUpgradeName2="images/backgrounds/themes/olympus/floors";
		kUpgradeName3="images/backgrounds/themes/olympus/statues";
		kUpgradeTitle1="upgrade_title_showers";
		kUpgradeTitle2="upgrade_title_floors";
		kUpgradeTitle3="upgrade_title_statues";
	end	

kUpgrade1Price = GetDecorUpgradePrice(1);
kUpgrade2Price = GetDecorUpgradePrice(2);
kUpgrade3Price = GetDecorUpgradePrice(3);

if(GetDecorUpgradeLevel(1,4) == 1) then	
	kSold1 = "upgrade_sold";
end

if(GetDecorUpgradeLevel(2,4) == 1) then	
	kSold2 = "upgrade_sold";
end

if(GetDecorUpgradeLevel(3,4) == 1) then	
	kSold3 = "upgrade_sold";
end


MakeDialog
{
	-- Name the modal dialog
	name="decors",
	Bitmap
	{
		image="images/ui/common/popup_intro",
		x=kCenter,
		y=kCenter,
		
		Text
		{
			font	= WelcomeFont,
			name	= "endlesschoice",
			x=0,
			y=kTitleY,
			w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "DecorTitle",
		};
--decor 1		
		Bitmap
		{
			image = "images/ui/common/upgradetype",
			x=kDecor1X - 20,
			y=kUpgradeTypeY,
		};
		Text
		{
			font	= PriceFont,
			name	= "decorType1",
			x=kDecor1X,
			y=kUpgradeTypeY + 3,
			w=100,h=22,
			flags=kHAlignCenter + kVAlignCenter,
			label = kUpgradeTitle1,
		};		
		Text
		{
			font	= PriceFont,
			name	= "decor1",
			x=kDecor1X,
			y=kUpgradePriceY+kTextDiffY,
			w=100,h=22,
			flags=kHAlignCenter + kVAlignCenter,
			label = "price",
		};
		Bitmap
		{
			image = "images/ui/common/upgradeslot",
			x=kDecor1X,
			y=kDecor1Y,
		};
		Bitmap
		{
			image = "images/ui/common/upgradeprize",
			x=kDecor1X - 20,
			y=kUpgradePriceY,
		};	
		Bitmap
		{			
			image=kUpgradeName1,
			x=kDecor1X,
			y=kDecor1Y,
		};
		Text
		{
			font	= SoldFont,
			name	= "Sold1",
			x=kDecor1X,
			y=kDecor1Y + 35,
			w=100,h=30,
			flags=kHAlignCenter + kVAlignCenter,
			label = kSold1,
		};
		Text
		{
			font	= PriceFont,
			name	= "decor1",
			x=kDecor1X - kDecorPriceTitleOffset,
			y=kUpgradePriceY+kTextDiffY,
			w=100,h=22,
			flags=kHAlignLeft + kVAlignCenter,
			label = "price",
		};
		Text
		{
			font	= PriceFont,
			name	= "decorprice1",
			x=kDecor1X - kDecorPriceTitleOffset + kDecor1PriceX,
			y=kUpgradePriceY+kTextDiffY,
			w=100,h=22,
			flags=kHAlignLeft + kVAlignCenter,
			label = kUpgrade1Price,
		};
		 
		SetStyle(FitnessButtonStyleTittleSmallBlue4),
		
		SBButton
		{
			x=kCenter - kButtonSpacingX,
			y=kButtonY - kButtonSpacingY,
			font = MenuButtonFont3,
			name="upgrade1",
			icon="assets/images/ui/buttons/icon/iconupgrade",
			-- label="upgradetitle",
			command = 
				function()
					if(ChooseDecor(1))then
						SetLabel("Sold1", GetString("upgrade_sold"));
						InitDecorPriceColor();
					end
				end
		};		
		Text
		{
			font = UpgradeButtonFont,
			x=kCenter - kButtonSpacingX,
			y=kButtonY - kButtonSpacingY-32,
			name="menutx",
			flags = kHAlignCenter + kVAlignCenter,
			label="upgradetitle",
		};

		
--decor 2		
		Bitmap
		{
			image = "images/ui/common/upgradetype",
			x=kDecor1X + kDecorSpaceX - 20,
			y=kUpgradeTypeY,
		};	
		Text
		{
			font	= PriceFont,
			name	= "decorType2",
			x=kDecor1X + kDecorSpaceX,
			y=kUpgradeTypeY + 3,
			w=100,h=22,
			flags=kHAlignCenter + kVAlignCenter,
			label = kUpgradeTitle2,
		};	
		Bitmap
		{
			image = "images/ui/common/upgradeslot",
			x=kDecor1X + kDecorSpaceX,
			y=kDecor1Y,
		};		
		Bitmap
		{
			image = "images/ui/common/upgradeprize",
			x=kDecor1X + kDecorSpaceX - 20,
			y=kUpgradePriceY,
		};
		Bitmap
		{
			image=kUpgradeName2,
			-- image="images/backgrounds/themes/boxingclub/showers",
			x=kDecor1X + kDecorSpaceX,
			y=kDecor1Y,
		};
		Text
		{
			font	= SoldFont,
			name	= "Sold2",
			x=kDecor1X + kDecorSpaceX,
			y=kDecor1Y + 35,
			w=100,h=30,
			flags=kHAlignCenter + kVAlignCenter,
			label = kSold2,
		};
		Text
		{
			font	= PriceFont,
			name	= "decor2",
			x=kDecor1X - kDecorPriceTitleOffset + kDecorSpaceX,
			y=kUpgradePriceY+kTextDiffY,
			w=100,h=22,
			flags=kHAlignLeft + kVAlignCenter,
			label = "price",
		};
		Text
		{
			font	= PriceFont,
			name	= "decorprice2",
			x=kDecor1X - kDecorPriceTitleOffset + kDecor1PriceX + kDecorSpaceX,
			y=kUpgradePriceY+kTextDiffY,
			w=100,h=22,
			flags=kHAlignLeft + kVAlignCenter,
			label = kUpgrade2Price,
		};
		SetStyle(FitnessButtonStyleTittleSmallBlue4),
		SBButton
		{
			x=kCenter,
			y=kButtonY - kButtonSpacingY,
			font = MenuButtonFont3,
			name="upgrade2",
			icon="assets/images/ui/buttons/icon/iconupgrade",
			-- label="upgradetitle",
			type = kPush,
			command = 
				function()
					if(ChooseDecor(2))then
						SetLabel("Sold2", GetString("upgrade_sold"));
						InitDecorPriceColor();
					end
				end
		};	
		Text
		{
			font = UpgradeButtonFont,
			x=kCenter,
			y=kButtonY - kButtonSpacingY-32,
			name="menutx",
			flags = kHAlignCenter + kVAlignCenter,
			label="upgradetitle",
		};

		
--decor 3
		Bitmap
		{
			image = "images/ui/common/upgradetype",
			x=kDecor1X + 2*kDecorSpaceX - 20,
			y=kUpgradeTypeY,
		};	
		Text
		{
			font	= PriceFont,
			name	= "decorType3",
			x=kDecor1X + 2*kDecorSpaceX,
			y=kUpgradeTypeY + 3,
			w=100,h=22,
			flags=kHAlignCenter + kVAlignCenter,
			label = kUpgradeTitle3,
		};		
		Bitmap
		{
			image = "images/ui/common/upgradeslot",
			x=kDecor1X + 2*kDecorSpaceX,
			y=kDecor1Y,
		};		
		Bitmap
		{
			image = "images/ui/common/upgradeprize",
			x=kDecor1X + 2*kDecorSpaceX - 20,
			y=kUpgradePriceY,
		};
		Bitmap
		{
			image=kUpgradeName3,
			-- image="images/backgrounds/themes/boxingclub/showers",
			x=kDecor1X + 2*kDecorSpaceX,
			y=kDecor1Y,
		};
		Text
		{
			font	= SoldFont,
			name	= "Sold3",
			x=kDecor1X + 2*kDecorSpaceX,
			y=kDecor1Y + 35,
			w=100,h=30,
			flags=kHAlignCenter + kVAlignCenter,
			label = kSold3,
		};
		Text
		{
			font	= PriceFont,
			name	= "decor2",
			x=kDecor1X - kDecorPriceTitleOffset  + 2*kDecorSpaceX,
			y=kUpgradePriceY+kTextDiffY,
			w=100,h=22,
			flags=kHAlignLeft + kVAlignCenter,
			label = "price",
		};
		Text
		{
			font	= PriceFont,
			name	= "decorprice3",
			x=kDecor1X - kDecorPriceTitleOffset + kDecor1PriceX + 2*kDecorSpaceX,
			y=kUpgradePriceY+kTextDiffY,
			w=100,h=22,
			flags=kHAlignLeft + kVAlignCenter,
			label = kUpgrade3Price,
		};
		SetStyle(FitnessButtonStyleTittleSmallBlue4),
		SBButton
		{
			x=kCenter + kButtonSpacingX,
			y=kButtonY - kButtonSpacingY,
			font = MenuButtonFont3,
			name="upgrade3",
			icon="assets/images/ui/buttons/icon/iconupgrade",
			-- label="upgradetitle",
			command = 
				function()
					if(ChooseDecor(3))then
						SetLabel("Sold3", GetString("upgrade_sold"));
						InitDecorPriceColor();
					end
				end
		};
		Text
		{
			font = UpgradeButtonFont,
			x=kCenter + kButtonSpacingX,
			y=kButtonY - kButtonSpacingY-32,
			name="menutx",
			flags = kHAlignCenter + kVAlignCenter,
			label="upgradetitle",
		};

		
		
--Close
		SetStyle(FitnessButtonStyleTittleXLBlueTxInside),
		SBButton
		{
			x=kCenter,
			y=kButtonY + 20,
			name="closeButton",
			label="close",			
			command = 
				function()
					PopModal("decors");--close = true	-- Just close this window
				end
		};
		
	},
}

InitDecorPriceColor();